# Judgment Call

I had a tough decision to make recently. 

### the business issue

The context was our business growth, as a Series A company, targeting our B round. More than $60MM valuation at Series A, we needed to raise $200-250MM in our B round.  The milestones to get there were something of a moving target.  A common hunch was that we would do well if we secured a new major partner that was tied to diversifying into another major line-of-business (LOB).  Getting there would require strong coordination from everyone, to plan, sell, and build, while executing on the growth of existing business.

### the situation

For this new LOB, a SaaS offering was one of the main concepts in development.  Several other ideas were tested, but were not getting as much traction as fast, regardless of how we could execute. We determined that we could offer a new product that used all of our existing infrastructure and services, with only the help of a new webapp that offered admin and portal features based on a range of users roles.

### intractable analysis

To get the SaaS offering right would require clear planning, specification, and execution speed.  While these are normal operational values, the tolerances for wobble were low because of slow client-dependent planning cycles — mixed with the need to ultimately deliver faster than the opportunity cost of their internal development.  Doing so would represent a major challenge in our startup environment.  Teams that would plan and design the offerings and product were recently hired, plus they did not have developed-relationships of working together.  OKRs showed our recent cadence was not working hard to maintain current operations.  A complex new project would introduce new forms of risk in addition to heightening existing risk.   The root of the matter needed to be solved in order to successfully deliver on any plan that would materialize a new LOB capable of solidifying our next venture round.

### A decision making process

A break-down of the specific patterns occurring aroused disagreement about the source and solution to each.  One of the core observations was a low team velocity.  That assessment came from several in leadership with experience delivering initiatives with similar feature-complexity.   The speed and depth of specification delivered from the product team would vary widely. It was possible that the existing personnel were simply asked too much, with too steep of a learning curve for what our startup could afford to educate and support.  

Engineering delivery also had limits that were throttled by toolchain, code typesafety, library support, and boilerplate.  The size of our team limited the support available for toolchain and environment, and this was after paying a premium to hire upper-level engineers.  While choosing a typesafe language (scala) had strengths, the toolchain, onboarding, and general availability of affordable candidate engineers were all factors in final delivery.  

At the time, Scala lacked libraries for quickly building admin apps and similar portal webapp patterns, while engineers on the team had taken an inflexible position on the importance of driving innovation in the scala community, by using it for all systems.  The absence of library support meant that we needed to build more boilerplate, or dedicate more senior-engineer time to developing generalized libraries.  Even in this break-down, there are many ways to look at these complexities, mixed with the moving-target of a client's needs.

I knew that any solution would need as much input as possible, and the socialization of that knowledge.  The socialization would not-only ensure we had a rich perspective, but also help those that were interested in an option we may not pick to feel aligned with a go-forward plan.  I realized this would take support from outside perspectives as well.  I considered how I would want perspective, in the same way.  It was also clear that different peoples' communications styles would require different meeting formats and hearing styles.  Due to normal time constraints, some of these discussions would need to to occur as a part of existing meetings.

### work to disconfirm the assumptions

I got feedback from people during meetings, and in 1:1 sessions.  I asked people in confidence, seeking 'tough choice' opinions of the situation, as well as in group settings where I supported each rationale and mediated dialogue.  I researched meetups and professional consultants in the community.  I discovered that many teams that epitomized 'scala vanguards' did not use it for the admin-style portal webapp that we were seeing as a route to Series B funding.  Instead they used non-typesafe languages for the flexibility of rapid changes and re-release, which was an option in a service-type that was more tolerant to program faults.  As well, long-standing non-typesafe language communities had build robust libraries and frameworks for delivering similar projects, and with similar rapid evolution of the delivery. 

I saw the option for delivering the target product using javascript, as the language was flexible and had a broad set of relevant libraries, while also we could implement typescript at any time.  Though most scala-committed teams seemed to chose ruby for this application, it was clear that our engineering culture would not be comfortable with a non-typesafe language.  I further validated this by building a POC app concept in ruby and rails, and launching it, in a couple days.  I used ruby because it would deliver faster than JavaScript or Spring/boot, the latter of which had cultural rejections in context to scala.  Despite the speed and flexibility of delivery, the demo met with many cultural rejections because of typesafety, and would clearly not be a supported option.  From this, javascript became a more-acceptable alternative.  It was clear that I would need to give support for a small team to form, by calling upon on those that were supportive in 1:1 or group contexts, to accomplish the target deliverable.   This route seemed to have the least uncertainties, particularly when considering the limited influence that I could have in the operations of other teams — and Series B depended on it.

### Alternatives and Options

None of the alternatives had a good ‘gut check’.  We could let the team BAU (business as usual), and trust individuals' advocacy that the way had been doing things would soon cross a threshold, and emerge new velocity and new confidence for all.  No one could speak for what those conditions of emergence might be.  Another option was to hire more staff.  The budget was not in place to do this, and even if we had it, there is an onboarding time before meaningful contribution. The onboarding time would be moreso, accounting for how that route needed to build and use custom libraries, against a moving target.  Another option offered was building the same library pattern I had found in meetups.  Though innovation involves risks, we could have accomplished it by swapping in more time of our most-senior engineers. This would risk our ability to debug many other live support and existing delivery issues. We could also try to outsource it, but similar budget limits existed as with hiring. As well, an outsourced project would have complexity to integrate and handoff. That strategy would also carry a risk if a partner audited our operations for that form the risk of relying on a vendor relationship.

### Rationale

I opted to form a small team that would use the non-scala strategy. Doing so would give us a typesafe option later, and would give us a wide range of lIbraries to rapidly prototype and bootstrap. These development liberties would allow us to pivot around uncertainties coming from the new teams, new strategy, and client dynamics.  By tapping people with an inherent motivation to do more than the team’s current culture allowed, I leverage their energy to help them grow and the company succeed. 

While the route I chose still met with several forms of resistance, I had enough autonomy in my role to enable me to form the beginning of this project team.  In the coming weeks, usable production MVP demos were launched. While that operation and teamwork was gelling, several security compliance requests were growing larger and more involved. I put a portion of attention into systematizing this work so that it would be own-able by less executive staff. I also had a depth appreciation for risk and compliance, and knew that the optics of how we performed would be significant to the clients.

### Results

These decisions and gut instincts were validated when ~1 month later the client was confident to sign a contract with us. Executive leadership had been able to sell the speed we could build a prototype, which won the comparisons to opportunity cost. The security work had de-risked working with us.  The efforts, done in advance, had given us leverage in the client relationship, and toward a B raise that would exceed $200MM - a further validation of the next large expansion in the value we provide. 
